/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs.sources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSource;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSourceType;
import dev.toma.gunsrpg.common.debuffs.sources.HurtByEntitySource;
import dev.toma.gunsrpg.common.init.ModDebuffSources;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.DamageSource;

public class HurtBySlimeSource
implements DebuffSource {
    public static final Codec<HurtBySlimeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("baseChance").forGetter(t -> Float.valueOf(t.baseChance)), (App)Codec.FLOAT.fieldOf("sizeIncrements").forGetter(t -> Float.valueOf(t.sizeIncrements))).apply((Applicative)instance, HurtBySlimeSource::new));
    private final float baseChance;
    private final float sizeIncrements;

    public HurtBySlimeSource(float baseChance, float sizeIncrements) {
        this.baseChance = baseChance;
        this.sizeIncrements = sizeIncrements;
    }

    @Override
    public float getChance(IDebuffContext context) {
        Entity entity;
        EntityType type;
        DamageSource source = context.getSource();
        if (HurtByEntitySource.isValidEntitySource(source) && (type = (entity = source.func_76364_f()).func_200600_R()) == EntityType.field_200743_ai) {
            int size = ((SlimeEntity)entity).func_70809_q();
            return this.baseChance + (float)size * this.sizeIncrements;
        }
        return 0.0f;
    }

    @Override
    public DebuffSourceType<?> getType() {
        return ModDebuffSources.HURT_BY_SLIME;
    }
}

